<?php

function privimetrics_inject_script($html = '') {
    $extId = 'privimetrics';

    $scriptUrl = ext_get_setting($extId, 'script_url');
    $keyCode   = ext_get_setting($extId, 'key_code');
    $noTrackIp = ext_get_setting($extId, 'notrack_ip', 1);

    if (empty($scriptUrl) || empty($keyCode)) {
        return $html;
    }

    $script  = "\n<!-- PriviMetrics for FlatlyPage -->\n";
    $script .= '<script src="' . htmlspecialchars($scriptUrl) . '"';
    
    if ($noTrackIp) {
        $script .= ' data-not-track-ip="true"';
    }

    $script .= ' data-privimetrics-code="' . htmlspecialchars($keyCode) . '"></script>' . "\n";

    return $html . $script;
}
