<?php
function get_extension_settings() {
    global $extensions;
    $extId = basename(__DIR__);
    $defaults = [
        'website_image' => 'false',
        'website_domain_path' => '',
        'contact_image_status' => 'false',
        'contact_image' => '',
        'page_image_status' => 'false',
        'page_image' => ''
    ];
    return array_merge($defaults, $extensions->getExtensionSettings($extId) ?? []);
}

function website_image_inject($data) {
    $settings = get_extension_settings();

    ob_start();
    ?>
    <div>
        <h3 style="font-size: 18px;">Website Image Settings</h3>

        <br>
        
        <?php 
        $fields = [
            ['Home Page', 'website_image', 'website_domain_path'],
            ['Contact Page', 'contact_image_status', 'contact_image'],
            ['Other Pages', 'page_image_status', 'page_image']
        ];

        foreach ($fields as $field): 
            $statusKey = $field[1];
            $pathKey = $field[2];
        ?>
        <div class="form-row" style="margin-bottom: 15px;">
            <div class="form-group">
                <label class="form-label"><strong><?= $field[0] ?></strong> Image</label>
                <select name="ext_<?= $statusKey ?>" class="form-input">
                    <option value="true" <?= ($settings[$statusKey] === 'true') ? 'selected' : '' ?>>Enabled</option>
                    <option value="false" <?= ($settings[$statusKey] === 'false') ? 'selected' : '' ?>>Disabled</option>
                </select>
            </div>
            <div class="form-group">
                <label class="form-label">Image Path (URL)</label>
                <input type="text" name="ext_<?= $pathKey ?>" class="form-input" 
                       value="<?= htmlspecialchars($settings[$pathKey], ENT_QUOTES, 'UTF-8') ?>" 
                       placeholder="example.com/image.png">
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php
    $html_content = str_replace(["\r", "\n"], '', ob_get_clean());
    ?>

    <script>
    document.addEventListener("DOMContentLoaded", function() {
        const container = document.getElementById("custom-settings-content");
        if (container) {
            const wrapper = document.createElement("div");
            wrapper.innerHTML = <?= json_encode($html_content) ?>;
            container.appendChild(wrapper);
        }
    });
    </script>
    <?php
    return $data;
}

function website_image_save($data) {
    global $extensions;
    $extId = basename(__DIR__);

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'save_settings') {
        
        $new_settings = [
            'website_image'        => ($_POST['ext_website_image'] === 'true' ? 'true' : 'false'),
            'website_domain_path'  => trim(strip_tags($_POST['ext_website_domain_path'] ?? '')),
            'contact_image_status' => ($_POST['ext_contact_image_status'] === 'true' ? 'true' : 'false'),
            'contact_image'        => trim(strip_tags($_POST['ext_contact_image'] ?? '')),
            'page_image_status'    => ($_POST['ext_page_image_status'] === 'true' ? 'true' : 'false'),
            'page_image'           => trim(strip_tags($_POST['ext_page_image'] ?? '')),
        ];

        $extensions->saveExtensionSettings($extId, $new_settings);
    }
    return $data;
}

function website_image_frontend($data) {
    $settings = get_extension_settings();
    
    $pageType = defined('CURRENT_PAGE') ? CURRENT_PAGE : 'default';

    $finalUrl = '';

    if ($pageType === 'home' && $settings['website_image'] === 'true') {
        $finalUrl = $settings['website_domain_path'];
    } elseif ($pageType === 'contact' && $settings['contact_image_status'] === 'true') {
        $finalUrl = $settings['contact_image'];
    } elseif ($settings['page_image_status'] === 'true') {
        $finalUrl = $settings['page_image'];
    }

    if (!empty($finalUrl)) {
        if (!preg_match("~^(?:f|ht)tps?://~i", $finalUrl)) {
            $finalUrl = "https://" . $finalUrl;
        }

        $cleanUrl = htmlspecialchars($finalUrl, ENT_QUOTES, 'UTF-8');
        echo "\n" . '    <meta property="og:image" content="' . $cleanUrl . '">' . "\n";
    }

    return $data;
}